/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.mixin.accessors.BaseSpawnerAccess;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;

public class SpawnerAgitatorEntity
extends AbstractSemiblockEntity {
    public SpawnerAgitatorEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public boolean canPlace(Direction facing) {
        return this.getBlockState().m_60734_() == Blocks.f_50085_;
    }

    @Override
    public void m_8119_() {
        BaseSpawner spawner;
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && (spawner = this.getSpawner()) != null && this.f_19797_ == 1) {
            this.setSpawnPersistentEntities(spawner, true);
        }
    }

    @Override
    public void doExtraCleanupTasks(boolean removingSemiblock) {
        BaseSpawner spawner;
        if (!this.f_19853_.f_46443_ && removingSemiblock && (spawner = this.getSpawner()) != null) {
            this.setSpawnPersistentEntities(spawner, false);
        }
    }

    private BaseSpawner getSpawner() {
        BaseSpawner baseSpawner;
        BlockEntity blockEntity = this.getCachedTileEntity();
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity s = (SpawnerBlockEntity)blockEntity;
            baseSpawner = s.m_59801_();
        } else {
            baseSpawner = null;
        }
        return baseSpawner;
    }

    private void setSpawnPersistentEntities(BaseSpawner spawner, boolean persistent) {
        ((BaseSpawnerAccess)spawner).getNextSpawnData().m_186567_().m_128379_("PersistenceRequired", persistent);
    }

    public static boolean isAgitated(BaseSpawner spawner) {
        BlockEntity be = spawner.getSpawnerBlockEntity();
        return be != null && SemiblockTracker.getInstance().getSemiblock(be.m_58904_(), be.m_58899_()) instanceof SpawnerAgitatorEntity;
    }
}

